unit userscript;

function buffWeaponDamage(e: IInterface): integer;
var
  nc, v, nv: Integer;
  val: String;
begin
  Result := 0;
  AddMessage('Adjusting all damage types by 200% on '+GetElementEditValues(e, 'EDID'));
  nc := 2; // increasing all types of ship weapon damage to 200%
  
  // Adjust ATTACK damage
  val := GetEditValue(ElementByPath(e, '[17]\[0]'));
  val := StringReplace(val, '.000000', '', [rfReplaceAll, rfIgnoreCase]);
  v := int(val);
  nv := v * nc;
  SetEditValue(ElementByPath(e, '[17]\[0]'), Format(nv, [GetEditValue(ElementByPath(e, '[17]\[0]')), IntToHex(FormID(e),8)]));

  // Adjust SHIELD damage
  val := GetEditValue(ElementByPath(e, '[18]\[0]\[1]'));
  v := int(val);
  nv := v * nc;
  SetEditValue(ElementByPath(e, '[18]\[0]\[1]'), Format(nv, [GetEditValue(ElementByPath(e, '[17]\[0]')), IntToHex(FormID(e),8)]));

  // Adjust EM damage
  val := GetEditValue(ElementByPath(e, '[18]\[1]\[1]'));
  v := int(val);
  nv := v * nc;
  SetEditValue(ElementByPath(e, '[18]\[1]\[1]'), Format(nv, [GetEditValue(ElementByPath(e, '[17]\[0]')), IntToHex(FormID(e),8)]));
end;

function adjustWeapons(e: IInterface): integer;
var
  etyp: String;
begin
  Result := 0;
  etyp := LeftStr(GetElementEditValues(e, 'EDID'),3);
  if etyp = 'sw_' then buffWeaponDamage(e);
end;

function boostEngineSpeedIfPresent(e: IInterface; k: String): integer;
var
  v, nv, nc: Integer;
  val, k1, k2, t: String;
begin
  Result := 0;
  t := 'SpaceshipEnginePartMaxForwardSpeed "Max Speed" [AVIF:00278988]';
  nc := 30; // increase Engine Speed by 5
  k1 := k+'[0]';
  k2 := k+'[1]';
  if ElementByPath(e, k1) <> nil then
  begin
    if GetEditValue(ElementByPath(e, k1)) = t then
    begin
	  AddMessage('Changing Engine Speed on '+GetElementEditValues(e, 'EDID'));
	  val := GetEditValue(ElementByPath(e, k2));
	  v := int(val);
	  nv := v + nc;
	  SetEditValue(ElementByPath(e, k2), Format(nv, [GetEditValue(ElementByPath(e, k2)), IntToHex(FormID(e),8)]));
    end;
  end;
end;

function adjustEngines(e: IInterface): integer;
var
  I: Integer;
  t1, t2, etyp: String;
begin
  Result := 0;
  t1 := 'gbf_DarkStar_ME';
  t2 := 'gbf_DarkStar_XE';
  etyp := LeftStr(GetElementEditValues(e, 'EDID'),Length(t1));
  if (etyp = t1) or (etyp = t2) then
  begin
    for I := 1 to 30 do boostEngineSpeedIfPresent(e, '[4]\[1]\[1]\[0]\['+IntToStr(I)+']\');
  end;
end;

function Process(e: IInterface): integer;
begin
  Result := 0;
  adjustWeapons(e);
  adjustEngines(e);
end;

end.